<?php
/* --------------------------------------------------------------
   LanguageFactory.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language;

use Webmozart\Assert\Assert;

/**
 * Class LanguageFactory
 *
 * @package Gambio\Core\Language\Model
 */
class LanguageFactory
{
    /**
     * @param array $languagesData
     *
     * @return Languages
     */
    public function createLanguages(array $languagesData): Languages
    {
        $languages = [];
        foreach ($languagesData as $languageData) {
            $languages[] = $this->createLanguage($languageData['id'], $languageData['code'], $languageData['name']);
        }
        
        return \Gambio\Core\Language\Model\Languages::create(...$languages);
    }
    
    
    /**
     * @param int    $id
     * @param string $code
     * @param string $name
     *
     * @return Language
     */
    public function createLanguage(int $id, string $code, string $name): Language
    {
        return \Gambio\Core\Language\Model\Language::create($this->createLanguageId($id),
                                                            $this->createLanguageCode($code),
                                                            $name);
    }
    
    
    /**
     * @param int $id
     *
     * @return LanguageId
     */
    public function createLanguageId(int $id): LanguageId
    {
        Assert::greaterThan($id, 0, 'The language ID must be greater than 0. Got: %s');
        
        return \Gambio\Core\Language\Model\LanguageId::create($id);
    }
    
    
    /**
     * @param string $code
     *
     * @return LanguageCode
     */
    public function createLanguageCode(string $code): LanguageCode
    {
        Assert::notWhitespaceOnly($code, 'The language code can not be empty.');
        Assert::length($code, 2, 'The language code can not have more than two digits. Got: %s');
        
        return \Gambio\Core\Language\Model\LanguageCode::create($code);
    }
}